#ifndef DISPLAYSWITCHER_H
#define DISPLAYSWITCHER_H

#include <QWidget>
#include <QVBoxLayout>
#include <QPushButton>
#include <QLabel>
#include <QProcess>
#include <QScreen>

class DisplaySwitcher : public QWidget
{
    Q_OBJECT

public:
    explicit DisplaySwitcher(QWidget *parent = nullptr);
    ~DisplaySwitcher();

    void showSwitcher();

protected:
    void keyPressEvent(QKeyEvent *event) override;
    void focusOutEvent(QFocusEvent *event) override;
    void mousePressEvent(QMouseEvent *event) override;
    void mouseMoveEvent(QMouseEvent *event) override;
    void mouseReleaseEvent(QMouseEvent *event) override;

private slots:
    void onPCOnlyClicked();
    void onDuplicateClicked();
    void onExtendClicked();
    void onSecondOnlyClicked();
    void onSwapDisplaysClicked();

private:
    void setupUI();
    void executeXrandrCommand(const QString &command);
    QString detectDisplays();
    void centerOnScreen();
    
    QVBoxLayout *mainLayout;
    QPushButton *btnPCOnly;
    QPushButton *btnDuplicate;
    QPushButton *btnExtend;
    QPushButton *btnSecondOnly;
    QPushButton *btnSwapDisplays;
    QLabel *titleLabel;
    QLabel *linkLabel;
    
    QString primaryDisplay;
    QString secondaryDisplay;
    QStringList allDisplays;
    int currentSelection;
    
    // Для перетаскивания окна
    bool dragging;
    QPoint dragPosition;
};

#endif // DISPLAYSWITCHER_H
