#!/bin/bash

# Скрипт настройки терминала GNOME в бордовых тонах madmentat.ru
# Автор: Mad Mentat

echo "Настройка терминала в стиле madmentat.ru..."

# Получаем UUID профиля по умолчанию
PROFILE=$(gsettings get org.gnome.Terminal.ProfilesList default | tr -d "'")

# Базовый путь к настройкам профиля
PROFILE_PATH="org.gnome.Terminal.Legacy.Profile:/org/gnome/terminal/legacy/profiles:/:$PROFILE/"

# Включаем использование цветовой темы
gsettings set "$PROFILE_PATH" use-theme-colors false

# Цвета фона и текста
gsettings set "$PROFILE_PATH" background-color '#4a0a0a'  # Темно-бордовый фон
gsettings set "$PROFILE_PATH" foreground-color '#e0e0e0'  # Светло-серый текст

# Палитра цветов (16 цветов ANSI)
# Бордовая схема с акцентами
gsettings set "$PROFILE_PATH" palette "['#2a0505', '#ff5555', '#50fa7f', '#f1fa8c', '#bd93f9', '#ff79c6', '#8be9fd', '#f8f8f2', '#6b1a1a', '#ff6e6e', '#69ff94', '#ffffa5', '#d6acff', '#ff92df', '#a4ffff', '#ffffff']"

# Настройка прозрачности (опционально)
gsettings set "$PROFILE_PATH" use-transparent-background true
gsettings set "$PROFILE_PATH" background-transparency-percent 5

# Включаем жирный шрифт
gsettings set "$PROFILE_PATH" allow-bold true

# Курсор
gsettings set "$PROFILE_PATH" cursor-shape 'block'
gsettings set "$PROFILE_PATH" cursor-blink-mode 'on'

# Скроллинг
gsettings set "$PROFILE_PATH" scrollback-unlimited false
gsettings set "$PROFILE_PATH" scrollback-lines 10000

# Название профиля
gsettings set "$PROFILE_PATH" visible-name 'Mad Mentat Burgundy'

echo ""
echo "✓ Терминал настроен!"
echo "✓ Цветовая схема: бордовая (madmentat.ru)"
echo "✓ Профиль: Mad Mentat Burgundy"
echo ""
echo "Перезапустите терминал чтобы увидеть изменения."
